from flask import Blueprint, jsonify
from datetime import datetime
from ..database import get_db_connection, handle_db_error
from .. import limiter

bp = Blueprint('legislators', __name__, url_prefix='/api')

@bp.route('/legislators')
@limiter.limit("30 per minute")  # Reasonable limit for legislator list
def get_legislators():
    try:
        conn = get_db_connection()
        cursor = conn.cursor(dictionary=True)
        
        cursor.execute("SELECT * FROM legislators ORDER BY name")
        legislators = cursor.fetchall()
        
        # Convert datetime objects to strings
        for legislator in legislators:
            for key, value in legislator.items():
                if isinstance(value, datetime):
                    legislator[key] = value.isoformat()
        
        return jsonify(legislators)
        
    except Exception as e:
        return handle_db_error(e)
    finally:
        if 'cursor' in locals():
            cursor.close()
        if 'conn' in locals():
            conn.close() 