# Gunicorn configuration file
import multiprocessing

# Server socket
bind = "127.0.0.1:5000"  # Only listen on localhost, Nginx will proxy
workers = multiprocessing.cpu_count() * 2 + 1  # Number of worker processes
worker_class = "sync"  # Use sync workers
timeout = 120  # Timeout in seconds

# Logging
accesslog = "/home/dontafk/ilga.dontafk.com/logs/gunicorn_access.log"
errorlog = "/home/dontafk/ilga.dontafk.com/logs/gunicorn_error.log"
loglevel = "info"

# Process naming
proc_name = "ilga_api"

# SSL (if not using Nginx)
# keyfile = "/path/to/keyfile"
# certfile = "/path/to/certfile"

# Security
limit_request_line = 4094  # Limit request line size
limit_request_fields = 100  # Limit number of header fields
limit_request_field_size = 8190  # Limit header field sizes 