from flask import Flask, jsonify
from flask_limiter import Limiter
from flask_limiter.util import get_remote_address

limiter = Limiter(
    key_func=get_remote_address,
    default_limits=["200 per day", "50 per hour"],
    storage_uri="memory://"
)

def create_app():
    app = Flask(__name__)
    
    # Initialize limiter with app
    limiter.init_app(app)
    
    # Error handler for rate limiting
    @app.errorhandler(429)  # Too Many Requests
    def ratelimit_handler(e):
        return jsonify({
            "error": "Rate limit exceeded",
            "message": str(e.description)
        }), 429
    
    # Import and register blueprints
    from .routes import bills, legislators
    app.register_blueprint(bills.bp)
    app.register_blueprint(legislators.bp)
    
    return app 